<?php 
if (Auth('admin')->User()->dashboard_style == "light") {
    $text = "dark";
    $bg = 'light';
} else {
    $text = "light";
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
@include('admin.topmenu')
@include('admin.sidebar')

<div class="main-panel">
    <div class="content bg-{{$bg}}">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-{{$text}}">Add Copy Trading Plan</h1>
                <p class="text-{{$text}}">Create a new copy trading plan and upload the expert trader’s profile image.</p>
            </div>
            
            <x-danger-alert/>
            <x-success-alert/>

            <div class="mb-5 row">
                <div class="col-lg-12">
                    <div class="p-3 card bg-{{$bg}}">
                        <form role="form" method="post" action="{{ route('addplan') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-row">

                                <!-- ✅ Expert Image Upload -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Expert Image</h5>
                                    <input 
                                        type="file" 
                                        name="expert_image" 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        accept="image/*" 
                                        onchange="previewImage(event)" 
                                        required
                                    >
                                    <small class="text-{{$text}}">Upload expert’s image (Recommended: 400x400px).</small>

                                    <div class="mt-3">
                                        <img 
                                            id="imagePreview" 
                                            src="{{ asset('assets/img/default-trader.jpg') }}" 
                                            alt="Preview" 
                                            style="max-width:150px; border-radius:10px; border:1px solid #ccc;"
                                        >
                                    </div>
                                </div>

                                <!-- ✅ Expert Name -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Expert Name</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter expert’s full name" 
                                        type="text" 
                                        name="expert_name" 
                                        required
                                    >
                                </div>

                                <!-- ✅ Strategy Overview -->
                                <div class="form-group col-md-12">
                                    <h5 class="text-{{$text}}">Strategy Overview</h5>
                                    <textarea 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        rows="3" 
                                        name="strategy_overview" 
                                        placeholder="Describe the expert’s trading strategy (optional)..."
                                    ></textarea>
                                </div>

                                <!-- ✅ Plan Name -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Plan Name</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter Copy Trading plan name" 
                                        type="text" 
                                        name="name" 
                                        required
                                    >
                                </div>

                                <!-- ✅ Plan Price -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Plan Price ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter plan price" 
                                        type="text" 
                                        name="price" 
                                        required
                                    >
                                    <small class="text-{{$text}}">This is the maximum amount a user can invest in this plan.</small>
                                </div>

                                <!-- ✅ Min / Max Investment -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Minimum Investment ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter minimum amount" 
                                        type="text" 
                                        name="min_price" 
                                        required
                                    >
                                </div>
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Maximum Investment ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter maximum amount" 
                                        type="text" 
                                        name="max_price" 
                                        required
                                    >
                                </div>

                                <!-- ✅ ROI Range -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Minimum Return ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter minimum return" 
                                        type="text" 
                                        name="minr" 
                                        required
                                    >
                                </div>
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Maximum Return ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter maximum return" 
                                        type="text" 
                                        name="maxr" 
                                        required
                                    >
                                </div>

                                <!-- ✅ Gift Bonus -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Gift Bonus ({{$settings->currency}})</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Optional bonus" 
                                        type="text" 
                                        name="gift" 
                                        value="0"
                                    >
                                    <small class="text-{{$text}}">Optional extra bonus for investors.</small>
                                </div>

                                <!-- ✅ Top-up Interval -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Interval</h5>
                                    <select class="form-control text-{{$text}} bg-{{$bg}}" name="t_interval">
                                        <option>Monthly</option>
                                        <option>Weekly</option>
                                        <option>Daily</option>
                                        <option>Hourly</option>
                                        <option>Every 30 Minutes</option>
                                    </select>
                                </div>

                                <!-- ✅ Top-up Type -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Type</h5>
                                    <select class="form-control text-{{$text}} bg-{{$bg}}" name="t_type">
                                        <option>Percentage</option>
                                        <option>Fixed</option>
                                    </select>
                                </div>

                                <!-- ✅ Top-up Amount -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Amount</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="Enter profit amount" 
                                        type="text" 
                                        name="t_amount" 
                                        required
                                    >
                                </div>

                                <!-- ✅ Duration -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Investment Duration</h5>
                                    <input 
                                        class="form-control text-{{$text}} bg-{{$bg}}" 
                                        placeholder="e.g. 1 Days, 2 Weeks" 
                                        type="text" 
                                        name="expiration" 
                                        required
                                    >
                                    <small class="text-{{$text}}">Example: 1 Days, 3 Weeks, or 2 Months.</small>
                                </div>

                                <!-- ✅ Submit -->
                                <div class="form-group col-md-12">
                                    <input type="submit" class="btn btn-primary" value="Add Copy Trading Plan">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // ✅ Live Image Preview
        function previewImage(event) {
            const output = document.getElementById('imagePreview');
            output.src = URL.createObjectURL(event.target.files[0]);
            output.style.display = 'block';
        }
    </script>
@endsection
