<?php
if (Auth('admin')->User()->dashboard_style == "light") {
    $text = "dark";
    $bg = 'light';
} else {
    $text = "light";
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
@include('admin.topmenu')
@include('admin.sidebar')

<div class="main-panel">
    <div class="content bg-{{Auth('admin')->User()->dashboard_style}}">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-{{$text}}">Copy Trading Experts</h1>
                <p class="text-{{$text}}">Manage and monitor your investment and copy trading expert plans below.</p>
            </div>

            <x-danger-alert/>
            <x-success-alert/>

            <div class="mb-5 row">
                <div class="mt-2 mb-3 col-lg-12">
                    <a class="btn btn-primary" href="{{route('newplan')}}">
                        <i class="fa fa-plus"></i> Add New Expert Plan
                    </a>
                </div>

                @forelse ($plans as $plan)
                <div class="col-lg-4 col-md-6">
                    <div class="card bg-{{$bg}} shadow border p-0 mb-4">

                        <!-- ✅ Expert Image -->
                        @php
                            $expertImage = asset('assets/img/default-trader.jpg'); // Default fallback

                            if (!empty($plan->expert_image)) {
                                $path = $plan->expert_image;

                                // ✅ Normalize path
                                if (str_starts_with($path, '/public/storage/experts/')) {
                                    // Correct format from controller
                                    $expertImage = url($path);
                                } elseif (str_starts_with($path, 'storage/experts/')) {
                                    // Older saved format
                                    $expertImage = url('/public/' . $path);
                                } elseif (str_starts_with($path, '/storage/experts/')) {
                                    // Leading slash variant
                                    $expertImage = url('/public' . $path);
                                } elseif (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . ltrim($path, '/'))) {
                                    // Local absolute path
                                    $expertImage = url('/public/storage/experts/' . basename($path));
                                }
                            }
                        @endphp

                        <img src="{{ $expertImage }}" 
                             alt="{{ $plan->expert_name ?? $plan->name }}" 
                             style="width:100%; height:220px; object-fit:cover; border-top-left-radius:10px; border-top-right-radius:10px;">

                        <!-- ✅ Card Body -->
                        <div class="p-3">
                            <h3 class="text-{{$text}} mb-1">{{$plan->name}}</h3>

                            @if(!empty($plan->expert_name))
                                <p class="text-muted mb-2"><strong>Expert:</strong> {{$plan->expert_name}}</p>
                            @endif

                            @if(!empty($plan->strategy_overview))
                                <p class="text-{{$text}}" style="font-size:14px;">
                                    {{ \Illuminate\Support\Str::limit($plan->strategy_overview, 90, '...') }}
                                </p>
                            @endif

                            <!-- ✅ Pricing -->
                            <div class="price-tag mb-3">
                                <span class="symbol text-{{$text}}">{{$settings->currency}}</span>
                                <span class="amount text-{{$text}}">{{$plan->price}}</span>
                            </div>

                            <!-- ✅ Plan Details -->
                            <div class="pricing-features">
                                <div class="feature text-{{$text}}">💼 Min Deposit:
                                    <span>{{$settings->currency}}{{$plan->min_price}}</span>
                                </div>
                                <div class="feature text-{{$text}}">💰 Max Deposit:
                                    <span>{{$settings->currency}}{{$plan->max_price}}</span>
                                </div>
                                <div class="feature text-{{$text}}">📈 ROI Range:
                                    <span>{{$settings->currency}}{{$plan->minr}} - {{$settings->currency}}{{$plan->maxr}}</span>
                                </div>
                                <div class="feature text-{{$text}}">🎁 Bonus:
                                    <span>{{$settings->currency}}{{$plan->gift}}</span>
                                </div>
                                <div class="feature text-{{$text}}">⏳ Duration:
                                    <span>{{$plan->expiration}}</span>
                                </div>
                            </div>

                            <!-- ✅ Action Buttons -->
                            <div class="mt-3 text-center">
                                <a href="{{route('editplan', $plan->id)}}" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                <a href="{{ url('admin/dashboard/trashplan') }}/{{$plan->id}}" 
                                   class="btn btn-danger btn-sm"
                                   onclick="return confirm('Are you sure you want to delete this plan?')">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-lg-8">
                    <div class="pricing-table card border bg-{{$bg}} shadow p-4">
                        <h4 class="text-{{$text}}">No Copy Trading Plans available yet. Click the button above to create one.</h4>
                    </div>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection
