<?php
	if (Auth::user()->dashboard_style == "light") {
		$bgmenu = "blue";
		$bg = "light";
		$text = "dark";
	} else {
		$bgmenu = "dark";
		$bg = "dark";
		$text = "light";
	}
?>
@extends('layouts.app')
@section('content')
@include('user.topmenu')
@include('user.sidebar')

<div class="main-panel bg-{{$bg}}">
	<div class="content bg-{{$bg}}">
		<div class="page-inner">
			<div class="mt-2 mb-4">
				<h1 class="title1 text-{{$text}}">Copy Trading Experts</h1>
				<p class="text-{{$text}}">Choose a professional trader to copy and grow your investment portfolio automatically.</p>
			</div>

			<x-danger-alert/>
			<x-success-alert/>

			<style>
				/* ================= Modern Card Styles ================= */
				.copy-expert-card {
					border-radius: 20px;
					overflow: hidden;
					transition: transform 0.3s ease, box-shadow 0.3s ease;
					margin-bottom: 30px;
					border: none;
					box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
				}
				.copy-expert-card:hover {
					transform: translateY(-8px);
					box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
				}

				/* Image Styling */
				.copy-expert-card img {
					width: 100%;
					height: 250px;
					object-fit: cover;
					border-top-left-radius: 20px;
					border-top-right-radius: 20px;
					transition: transform 0.3s ease;
				}
				.copy-expert-card img:hover {
					transform: scale(1.05);
				}
				@media (max-width: 768px) {
					.copy-expert-card img {
						height: 200px;
					}
				}

				/* Card Body */
				.copy-expert-body {
					padding: 25px 20px;
				}
				.copy-expert-body h3 {
					font-weight: 700;
					margin-bottom: 10px;
					font-size: 1.25rem;
				}
				.copy-expert-body p {
					font-size: 0.95rem;
					color: #6c757d;
				}
				.copy-expert-body .feature {
					font-size: 14px;
					margin: 6px 0;
					display: flex;
					justify-content: space-between;
					align-items: center;
					padding: 5px 8px;
					border-radius: 10px;
					background-color: rgba(0,0,0,0.03);
				}
				.copy-expert-body .feature span {
					font-weight: 600;
				}

				/* Form Inputs & Buttons */
				.copy-expert-body input.form-control {
					border-radius: 10px;
					border: 1px solid rgba(0,0,0,0.1);
				}
				.copy-expert-body button.btn-primary {
					border-radius: 12px;
					padding: 10px;
					transition: all 0.3s ease;
				}
				.copy-expert-body button.btn-primary:hover {
					background-color: #004085;
				}

				/* Page Heading & Text */
				.mt-2.mb-4 h1 {
					font-size: 2rem;
					font-weight: 700;
				}
				.mt-2.mb-4 p {
					font-size: 1rem;
					line-height: 1.6;
				}
			</style>

			<div class="row">
				@forelse ($plans as $plan)
				<div class="col-lg-4 col-md-6">
					<div class="card bg-{{$bg}} shadow copy-expert-card">

						<!-- ✅ Expert Image -->
						@php
							$defaultImage = asset('assets/img/default-trader.jpg'); // fallback
							$expertImage = $defaultImage;

							if (!empty($plan->expert_image)) {
								$filename = basename($plan->expert_image);
								$expertImage = url('public/storage/experts/' . $filename);
							}
						@endphp

						<img src="{{ $expertImage }}" alt="{{ $plan->expert_name ?? $plan->name }} Expert Image">

						<!-- ✅ Card Body -->
						<div class="copy-expert-body text-{{$text}}">
							<h3>{{ $plan->expert_name ?? $plan->name }}</h3>

							@if(!empty($plan->strategy_overview))
								<p class="text-muted mb-3">{{ Str::limit($plan->strategy_overview, 100) }}</p>
							@else
								<p class="text-muted mb-3">Professional Copy Trader</p>
							@endif

							<div class="feature">💼 Minimum Deposit: <span class="text-{{$text}}">{{$settings->currency}}{{$plan->min_price}}</span></div>
							<div class="feature">💰 Maximum Deposit: <span class="text-{{$text}}">{{$settings->currency}}{{$plan->max_price}}</span></div>
							<div class="feature">📈 ROI Range: <span class="text-{{$text}}">{{$settings->currency}}{{$plan->minr}} - {{$settings->currency}}{{$plan->maxr}}</span></div>
							<div class="feature">🎁 Bonus: <span class="text-{{$text}}">{{$settings->currency}}{{$plan->gift}}</span></div>
							<div class="feature">⏳ Duration: <span class="text-{{$text}}">{{$plan->expiration}}</span></div>

							<br>
							<form method="post" action="{{ route('joinplan') }}">
								@csrf
								<h6>Amount to start with</h6>
								<input 
									type="number" 
									min="{{$plan->min_price}}" 
									max="{{$plan->max_price}}" 
									name="iamount" 
									placeholder="{{$settings->currency.$plan->price}}" 
									class="form-control text-{{$text}} bg-{{$bg}} mb-3" 
									required
								>
								<input type="hidden" name="duration" value="{{$plan->expiration}}">
								<input type="hidden" name="id" value="{{ $plan->id }}">
								<button type="submit" class="btn btn-primary btn-block">Copy This Trader</button>
							</form>
						</div>
					</div>
				</div>
				@empty
				<div class="col-lg-4">
					<div class="card bg-{{$bg}} p-4 border text-{{$text}}">
						<h4>No Copy Trading Expert available at the moment.</h4>
					</div>
				</div>
				@endforelse
			</div>
		</div>
	</div>
</div>
@endsection
