

<?php $__env->startSection('title', 'Create Account'); ?>

<?php $__env->startSection('styles'); ?>
##parent-placeholder-bf62280f159b1468fff0c96540f3989d41279669##
<style>
    /* Body & Background */
    body {
        background: linear-gradient(135deg, #1a1a1a 0%, #2b2b2b 100%);
        color: #fff;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        position: relative;
        overflow: hidden;
    }

    body::before {
        content: '';
        position: absolute;
        top: -150px;
        left: -150px;
        width: 500px;
        height: 500px;
        background: rgba(13, 110, 253, 0.12);
        border-radius: 50%;
        transform: rotate(45deg);
        z-index: 0;
    }

    body::after {
        content: '';
        position: absolute;
        bottom: -200px;
        right: -100px;
        width: 400px;
        height: 400px;
        background: rgba(255, 193, 7, 0.12);
        border-radius: 50%;
        transform: rotate(-30deg);
        z-index: 0;
    }

    .auth {
        width: 100%;
        padding: 40px 0;
        position: relative;
        z-index: 1;
    }

    .auth__logo {
        display: block;
        margin: 0 auto 20px auto;
        max-width: 150px;
    }

    .login-page {
        border-radius: 12px !important;
        background: #1e1e1e;
        color: #f1f1f1;
        overflow: hidden;
        box-shadow: 0 8px 20px rgba(0,0,0,0.4);
        position: relative;
        z-index: 2;
    }

    .card-title {
        font-size: 22px;
        font-weight: 700;
        margin-bottom: 15px;
        color: #fff;
    }

    .login-form label {
        font-weight: 600;
        font-size: 14px;
        color: #ccc;
    }

    .login-form input,
    .login-form select {
        border-radius: 10px;
        padding: 12px 15px 12px 40px;
        border: 1px solid #444;
        background: #2a2a2a;
        color: #fff;
        transition: all 0.2s ease-in-out;
    }

    .login-form input:focus,
    .login-form select:focus {
        border-color: #0d6efd;
        background: #333;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.3);
    }

    .login-form i {
        position: absolute;
        top: 50%;
        left: 12px;
        transform: translateY(-50%);
        color: #bbb;
    }

    .btn.pad {
        border-radius: 10px;
        padding: 12px;
        font-size: 16px;
        font-weight: bold;
        background: #0d6efd;
        border: none;
        transition: 0.3s ease-in-out;
    }

    .btn.pad:hover {
        background-color: #0b5ed7;
        transform: scale(1.03);
    }

    .forgot-pass a {
        font-size: 13px;
        color: #bbb;
    }

    .forgot-pass a:hover {
        color: #fff;
    }

    .alert {
        border-radius: 10px;
        font-size: 14px;
    }

    .text-center p {
        font-size: 14px;
        color: #ccc;
    }

    .text-center a {
        color: #0d6efd;
    }

    .text-center a:hover {
        color: #0b5ed7;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="auth">
    <div class="container">
        <div class="pb-3 row justify-content-center">
            <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">
                
                <a href="/">
                    <img src="<?php echo e(asset('storage/app/public/photos/'.$settings->logo)); ?>" alt="Logo" class="mb-3 img-fluid auth__logo">
                </a>
                
                <?php if(Session::has('status')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(Session::get('status')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <button type="button" class="text-white close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="shadow card login-page border-1">
                    <div class="card-body">
                        <h4 class="text-center card-title">Create an Account</h4>
                        <form method="POST" action="<?php echo e(route('register')); ?>" class="mt-4 login-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <!-- Username -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Username <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="user" class="fea icon-sm icons"></i>
                                            <input type="text" class="pl-5 form-control" name="username" placeholder="Enter Unique Username" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Full Name -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Full Name <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="user-check" class="fea icon-sm icons"></i>
                                            <input type="text" class="pl-5 form-control" name="name" value="<?php echo e(old('name')); ?>" placeholder="Enter Full Name" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Email -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Your Email <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="mail" class="fea icon-sm icons"></i>
                                            <input type="email" class="pl-5 form-control" name="email" value="<?php echo e(old('email')); ?>" placeholder="name@example.com" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Phone -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Phone Number <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="phone" class="fea icon-sm icons"></i>
                                            <input type="text" class="pl-5 form-control" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="Enter Phone number" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Password -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Password <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="key" class="fea icon-sm icons"></i>
                                            <input type="password" class="pl-5 form-control" name="password" placeholder="Enter Password" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Confirm Password -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Confirm Password <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="key" class="fea icon-sm icons"></i>
                                            <input type="password" class="pl-5 form-control" name="password_confirmation" placeholder="Confirm Password" required>
                                        </div>
                                    </div>
                                </div>

                                <!-- Country -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Country <span class="text-danger">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="map-pin" class="fea icon-sm icons"></i>
                                            <select class="pl-5 form-control" name="country" required>
                                                <option selected disabled>Choose Country</option>
                                                <?php echo $__env->make('auth.countries', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Referral -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Referral ID</label>
                                        <div class="position-relative">
                                            <i data-feather="user" class="fea icon-sm icons"></i>
                                            <input type="text" class="pl-5 form-control" name="ref_by" value="<?php echo e(Session::get('ref_by') ?? ''); ?>" placeholder="Optional referral ID" readonly="<?php echo e(Session::has('ref_by') ? 'readonly' : ''); ?>">
                                        </div>
                                    </div>
                                </div>

                                <!-- Captcha -->
                                <?php if($settings->captcha == "true"): ?>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <?php echo NoCaptcha::display(); ?>

                                    </div>
                                </div>
                                <?php endif; ?>

                                <!-- Terms -->
                                <?php if($terms->useterms =='yes'): ?>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="customCheck1" required>
                                            <label class="custom-control-label" for="customCheck1">
                                                I Accept the <a href="<?php echo e(route('privacy')); ?>" class="text-primary">Terms And Privacy Policy</a>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <!-- Submit -->
                                <div class="mb-0 col-lg-12">
                                    <button class="btn btn-primary btn-block pad" type="submit">Register</button>
                                </div>

                                <!-- Login link -->
                                <div class="text-center col-12">
                                    <p class="mt-3 mb-0">
                                        <small class="mr-2">Already have an account?</small>
                                        <a href="<?php echo e(route('login')); ?>" class="font-weight-bold">Login</a>
                                    </p>
                                </div>

                                <!-- Footer -->
                                <div class="text-center col-12">
                                    <p class="mt-4 mb-0">
                                        <small>&copy; Copyright <?php echo e(date('Y')); ?> &nbsp; <?php echo e($settings->site_name); ?> &nbsp; All Rights Reserved.</small>
                                    </p>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
##parent-placeholder-16728d18790deb58b3b8c1df74f06e536b532695##
<script>
    $('#input1').on('keypress', function(e) {
        return e.which !== 32;
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/victorio/federalstockbond.com/user/resources/views/auth/register.blade.php ENDPATH**/ ?>