<?php
if (Auth('admin')->User()->dashboard_style == "light") {
    $text = "dark";
    $bg = 'light';
} else {
    $text = "light";
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
@include('admin.topmenu')
@include('admin.sidebar')

<div class="main-panel">
    <div class="content bg-{{$bg}}">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-{{$text}}">Update Copy Trading Plan</h1>
                <p class="text-{{$text}}">Modify existing investment plans or copy trading expert details below.</p>
            </div>

            <x-danger-alert/>
            <x-success-alert/>

            <div class="mb-5 row">
                <div class="col-lg-12">
                    <div class="p-3 card bg-{{$bg}}">

                        <form role="form" method="post" action="{{ route('updateplan') }}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{ $plan->id }}">

                            <div class="form-row">

                                <!-- ✅ Expert Image -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Expert Image</h5>
                                    @php
                                        $expertImage = asset('assets/img/default-trader.jpg'); // Default fallback

                                        if (!empty($plan->expert_image)) {
                                            $path = $plan->expert_image;

                                            // Handle different stored formats
                                            if (str_starts_with($path, '/public/storage/experts/')) {
                                                $expertImage = url($path);
                                            } elseif (str_starts_with($path, 'storage/experts/')) {
                                                $expertImage = url('/public/' . $path);
                                            } elseif (str_starts_with($path, '/storage/experts/')) {
                                                $expertImage = url('/public' . $path);
                                            } elseif (file_exists(public_path($path))) {
                                                $expertImage = asset($path);
                                            }
                                        }
                                    @endphp

                                    <img id="imagePreview" src="{{ $expertImage }}" alt="Expert Image"
                                         style="max-width:150px; border-radius:10px; margin-bottom:10px; border:1px solid #ccc;">
                                    <input type="file" name="expert_image"
                                           class="form-control text-{{$text}} bg-{{$bg}}"
                                           accept="image/*" onchange="previewImage(event)">
                                    <small class="text-{{$text}}">Upload or replace the expert’s photo (400x400px recommended).</small>
                                </div>

                                <!-- Expert Name -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Expert Name</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->expert_name }}"
                                           placeholder="Enter expert’s full name"
                                           type="text" name="expert_name" required>
                                </div>

                                <!-- Strategy Overview -->
                                <div class="form-group col-md-12">
                                    <h5 class="text-{{$text}}">Strategy Overview</h5>
                                    <textarea class="form-control text-{{$text}} bg-{{$bg}}" rows="3"
                                              name="strategy_overview"
                                              placeholder="Describe the expert’s strategy...">{{ $plan->strategy_overview }}</textarea>
                                </div>

                                <!-- Plan Name -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Plan Name</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->name }}"
                                           placeholder="Enter plan name"
                                           type="text" name="name" required>
                                </div>

                                <!-- Plan Price -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Plan Price ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->price }}"
                                           placeholder="Enter plan price"
                                           type="text" name="price" required>
                                    <small class="text-{{$text}}">Maximum amount investors can put into this plan.</small>
                                </div>

                                <!-- Min / Max Investment -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Minimum Investment ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->min_price }}"
                                           placeholder="Enter minimum amount"
                                           type="text" name="min_price" required>
                                </div>

                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Maximum Investment ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->max_price }}"
                                           placeholder="Enter maximum amount"
                                           type="text" name="max_price" required>
                                </div>

                                <!-- ROI -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Minimum Return ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->minr }}"
                                           type="text" name="minr" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Maximum Return ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->maxr }}"
                                           type="text" name="maxr" required>
                                </div>

                                <!-- Gift -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Gift Bonus ({{$settings->currency}})</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->gift }}"
                                           type="text" name="gift">
                                </div>

                                <!-- Top-up Interval -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Interval</h5>
                                    <select class="form-control text-{{$text}} bg-{{$bg}}" name="t_interval">
                                        <option selected>{{ $plan->increment_interval }}</option>
                                        <option>Monthly</option>
                                        <option>Weekly</option>
                                        <option>Daily</option>
                                        <option>Hourly</option>
                                        <option>Every 30 Minutes</option>
                                    </select>
                                </div>

                                <!-- Top-up Type -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Type</h5>
                                    <select class="form-control text-{{$text}} bg-{{$bg}}" name="t_type">
                                        <option selected>{{ $plan->increment_type }}</option>
                                        <option>Percentage</option>
                                        <option>Fixed</option>
                                    </select>
                                </div>

                                <!-- Top-up Amount -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Top up Amount</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->increment_amount }}"
                                           placeholder="Enter profit amount"
                                           type="text" name="t_amount" required>
                                </div>

                                <!-- Duration -->
                                <div class="form-group col-md-6">
                                    <h5 class="text-{{$text}}">Investment Duration</h5>
                                    <input class="form-control text-{{$text}} bg-{{$bg}}"
                                           value="{{ $plan->expiration }}"
                                           placeholder="e.g. 1 Days, 2 Weeks"
                                           type="text" name="expiration" required>
                                </div>

                                <!-- Submit -->
                                <div class="form-group col-md-12">
                                    <input type="submit" class="btn btn-primary" value="Update Plan">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function previewImage(event) {
            const output = document.getElementById('imagePreview');
            output.src = URL.createObjectURL(event.target.files[0]);
            output.style.display = 'block';
        }
    </script>
@endsection
