@extends('layouts.guest')
@section('title', 'Manager Login')

@section('styles')
@parent
<style>
/* Full page background */
.auth {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #0d0d1f 0%, #1a1a2e 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Login card styling */
.login-page {
    border-radius: 1rem;
    padding: 2rem;
    max-width: 100%;
}

/* Logo on top of login card */
.auth__logo {
    display: block;
    margin: 0 auto 1.5rem;
    max-width: 180px;
}

/* Input icons */
.form-control {
    height: 45px;
}

.position-relative i {
    position: absolute;
    top: 50%;
    left: 15px;
    transform: translateY(-50%);
    color: #6c757d;
}

/* Input padding to prevent overlap with icons */
.pl-5 {
    padding-left: 2.5rem !important;
}

/* Buttons */
.btn-block {
    padding: 0.6rem;
    font-weight: 600;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .login-page {
        padding: 1.5rem;
    }

    .auth__logo {
        max-width: 140px;
    }
}
</style>
@endsection

@section('content')
<section class="auth">
    <div class="container">
        <div class="row justify-content-center pb-3">
            <!-- Wider column for desktop -->
            <div class="col-12 col-sm-10 col-md-8 col-lg-6 col-xl-5">

                <!-- Logo -->
                <a href="/"><img src="{{ asset('storage/app/public/photos/'.$settings->logo) }}" alt="{{$settings->site_name}}" class="mb-3 img-fluid auth__logo"></a>

                <!-- Session Message -->
                @if(Session::has('message'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ Session::get('message') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <!-- Login Card -->
                <div class="card bg-white shadow login-page">
                    <div class="card-body">
                        <h4 class="text-center card-title mb-4">Manager Login</h4>

                        <form method="POST" action="{{ route('adminlogin') }}" class="login-form">
                            @csrf
                            <div class="form-group position-relative mb-3">
                                <label>Your Email <span class="text-danger">*</span></label>
                                <i data-feather="mail" class="fea icon-sm icons"></i>
                                <input type="email" class="pl-5 form-control" name="email" value="{{ old('email') }}" id="email" placeholder="name@example.com" required>
                            </div>

                            <div class="form-group position-relative mb-3">
                                <label>Password <span class="text-danger">*</span></label>
                                <i data-feather="key" class="fea icon-sm icons"></i>
                                <input type="password" class="pl-5 form-control" name="password" id="password" placeholder="Enter Password" required>
                            </div>

                            <div class="mb-3">
                                <button class="btn btn-primary btn-block pad" type="submit">Sign in</button>
                            </div>

                            <div class="text-center mt-4">
                                <small class="text-dark">&copy; {{date('Y')}} {{$settings->site_name}}. All Rights Reserved.</small>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- End Login Card -->

            </div>
        </div>
    </div>
</section>
@endsection

@section('scripts')
@parent
<script>
    // Feather icons initialization if not already
    if(typeof feather !== 'undefined') {
        feather.replace();
    }
</script>
@endsection
