<?php
	if (Auth::user()->dashboard_style == "light") {
		$bgmenu = "blue";
		$bg = "light";
		$text = "dark";
	} else {
		$bgmenu = "dark";
		$bg = "dark";
		$text = "light";
	}
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('user.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('user.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="main-panel bg-<?php echo e($bg); ?>">
	<div class="content bg-<?php echo e($bg); ?>">
		<div class="page-inner">
			<div class="mt-2 mb-4">
				<h1 class="title1 text-<?php echo e($text); ?>">Copy Trading Experts</h1>
				<p class="text-<?php echo e($text); ?>">Choose a professional trader to copy and grow your investment portfolio automatically.</p>
			</div>

			<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
			<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

			<style>
				/* ================= Modern Card Styles ================= */
				.copy-expert-card {
					border-radius: 20px;
					overflow: hidden;
					transition: transform 0.3s ease, box-shadow 0.3s ease;
					margin-bottom: 30px;
					border: none;
					box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
				}
				.copy-expert-card:hover {
					transform: translateY(-8px);
					box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
				}

				/* Image Styling */
				.copy-expert-card img {
					width: 100%;
					height: 250px;
					object-fit: cover;
					border-top-left-radius: 20px;
					border-top-right-radius: 20px;
					transition: transform 0.3s ease;
				}
				.copy-expert-card img:hover {
					transform: scale(1.05);
				}
				@media (max-width: 768px) {
					.copy-expert-card img {
						height: 200px;
					}
				}

				/* Card Body */
				.copy-expert-body {
					padding: 25px 20px;
				}
				.copy-expert-body h3 {
					font-weight: 700;
					margin-bottom: 10px;
					font-size: 1.25rem;
				}
				.copy-expert-body p {
					font-size: 0.95rem;
					color: #6c757d;
				}
				.copy-expert-body .feature {
					font-size: 14px;
					margin: 6px 0;
					display: flex;
					justify-content: space-between;
					align-items: center;
					padding: 5px 8px;
					border-radius: 10px;
					background-color: rgba(0,0,0,0.03);
				}
				.copy-expert-body .feature span {
					font-weight: 600;
				}

				/* Form Inputs & Buttons */
				.copy-expert-body input.form-control {
					border-radius: 10px;
					border: 1px solid rgba(0,0,0,0.1);
				}
				.copy-expert-body button.btn-primary {
					border-radius: 12px;
					padding: 10px;
					transition: all 0.3s ease;
				}
				.copy-expert-body button.btn-primary:hover {
					background-color: #004085;
				}

				/* Page Heading & Text */
				.mt-2.mb-4 h1 {
					font-size: 2rem;
					font-weight: 700;
				}
				.mt-2.mb-4 p {
					font-size: 1rem;
					line-height: 1.6;
				}
			</style>

			<div class="row">
				<?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
				<div class="col-lg-4 col-md-6">
					<div class="card bg-<?php echo e($bg); ?> shadow copy-expert-card">

						<!-- ✅ Expert Image -->
						<?php
							$defaultImage = asset('assets/img/default-trader.jpg'); // fallback
							$expertImage = $defaultImage;

							if (!empty($plan->expert_image)) {
								$filename = basename($plan->expert_image);
								$expertImage = url('public/storage/experts/' . $filename);
							}
						?>

						<img src="<?php echo e($expertImage); ?>" alt="<?php echo e($plan->expert_name ?? $plan->name); ?> Expert Image">

						<!-- ✅ Card Body -->
						<div class="copy-expert-body text-<?php echo e($text); ?>">
							<h3><?php echo e($plan->expert_name ?? $plan->name); ?></h3>

							<?php if(!empty($plan->strategy_overview)): ?>
								<p class="text-muted mb-3"><?php echo e(Str::limit($plan->strategy_overview, 100)); ?></p>
							<?php else: ?>
								<p class="text-muted mb-3">Professional Copy Trader</p>
							<?php endif; ?>

							<div class="feature">💼 Minimum Deposit: <span class="text-<?php echo e($text); ?>"><?php echo e($settings->currency); ?><?php echo e($plan->min_price); ?></span></div>
							<div class="feature">💰 Maximum Deposit: <span class="text-<?php echo e($text); ?>"><?php echo e($settings->currency); ?><?php echo e($plan->max_price); ?></span></div>
							<div class="feature">📈 ROI Range: <span class="text-<?php echo e($text); ?>"><?php echo e($settings->currency); ?><?php echo e($plan->minr); ?> - <?php echo e($settings->currency); ?><?php echo e($plan->maxr); ?></span></div>
							<div class="feature">🎁 Bonus: <span class="text-<?php echo e($text); ?>"><?php echo e($settings->currency); ?><?php echo e($plan->gift); ?></span></div>
							<div class="feature">⏳ Duration: <span class="text-<?php echo e($text); ?>"><?php echo e($plan->expiration); ?></span></div>

							<br>
							<form method="post" action="<?php echo e(route('joinplan')); ?>">
								<?php echo csrf_field(); ?>
								<h6>Amount to start with</h6>
								<input 
									type="number" 
									min="<?php echo e($plan->min_price); ?>" 
									max="<?php echo e($plan->max_price); ?>" 
									name="iamount" 
									placeholder="<?php echo e($settings->currency.$plan->price); ?>" 
									class="form-control text-<?php echo e($text); ?> bg-<?php echo e($bg); ?> mb-3" 
									required
								>
								<input type="hidden" name="duration" value="<?php echo e($plan->expiration); ?>">
								<input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
								<button type="submit" class="btn btn-primary btn-block">Copy This Trader</button>
							</form>
						</div>
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
				<div class="col-lg-4">
					<div class="card bg-<?php echo e($bg); ?> p-4 border text-<?php echo e($text); ?>">
						<h4>No Copy Trading Expert available at the moment.</h4>
					</div>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/victorio/federalstockbond.com/user/resources/views/user/mplans.blade.php ENDPATH**/ ?>