<!-- Sidebar -->

<div class="sidebar sidebar-style-2" data-background-color="<?php echo e($bg); ?>">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <!-- User Info -->
            <div class="user py-3 text-center border-bottom">
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true" class="d-flex flex-column align-items-center">
                        <img src="<?php echo e(Auth::user()->profile_photo_url ?? asset('assets/img/default-avatar.png')); ?>" alt="User Avatar" class="rounded-circle mb-2" width="60" height="60">
                        <span class="font-weight-bold text-light"><?php echo e(Auth::user()->name); ?></span>
                        <span class="caret mt-1"></span>
                    </a>
                    <div class="collapse in mt-2" id="collapseExample">
                        <ul class="nav flex-column">
                            <li class="nav-item">
                                <a href="<?php echo e(route('profile')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light">
                                    <i class="fas fa-user-cog mr-2"></i>
                                    <span>Account Settings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <ul class="nav nav-primary flex-column mt-3">
                <li class="nav-item <?php echo e((request()->routeIs('dashboard')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('/dashboard')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fas fa-home mr-2"></i>
                        <p class="mb-0">Dashboard</p>
                    </a>
                </li>

                <li class="nav-item d-md-none <?php echo e((request()->routeIs('deposits') || request()->routeIs('payment')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/deposits')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-download mr-2"></i>
                        <p class="mb-0">Fund your Account</p>
                    </a>
                </li>

                <li class="nav-item d-md-none <?php echo e((request()->routeIs('withdrawalsdeposits') || request()->routeIs('withdrawfunds')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/withdrawals')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-arrow-alt-circle-up mr-2"></i>
                        <p class="mb-0">Withdraw Funds</p>
                    </a>
                </li>

                <li class="nav-item <?php echo e((request()->routeIs('tradinghistory')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/tradinghistory')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-signal mr-2"></i>
                        <p class="mb-0">Profit Record</p>
                    </a>
                </li>

                <li class="nav-item <?php echo e((request()->routeIs('accounthistory')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/accounthistory')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-briefcase mr-2"></i>
                        <p class="mb-0">Transactions History</p>
                    </a>
                </li>

                <?php if($moresettings->use_crypto_feature == 'true'): ?>
                <li class="nav-item <?php echo e((request()->routeIs('assetbalance')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('assetbalance')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-coins mr-2"></i>
                        <p class="mb-0">Crypto Exchange</p>
                    </a>
                </li>
                <?php endif; ?>

                <?php if($settings->subscription_service == 'on'): ?>
                <li class="nav-item <?php echo e((request()->routeIs('subtrade')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/subtrade')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-th mr-2"></i>
                        <p class="mb-0">Subscription Trade</p>
                    </a>
                </li>
                <?php endif; ?>

                <!-- Collapsible Copy Trading -->
                <li class="nav-item <?php echo e((request()->routeIs('mplans') || request()->routeIs('myplans')) ? 'active' : ''); ?>">
                    <a data-toggle="collapse" href="#mpack" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex justify-content-between align-items-center">
                        <div>
                            <i class="fas fa-cubes mr-2"></i>
                            <p class="mb-0 d-inline">Copy Trading</p>
                        </div>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse" id="mpack">
                        <ul class="nav nav-collapse flex-column pl-4">
                            <li>
                                <a href="<?php echo e(url('dashboard/buy-plan')); ?>" class="nav-link text-light py-1 hover-bg-light rounded">
                                    Copy An Expert
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(url('dashboard/myplans')); ?>" class="nav-link text-light py-1 hover-bg-light rounded">
                                    My Copy Trades
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item <?php echo e((request()->routeIs('referuser')) ? 'active' : ''); ?>">
                    <a href="https://federalstockfund.dpage.dev/user/choose-wallet.php" target="_blank" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-recycle mr-2"></i>
                        <p class="mb-0">Connect wallet</p>
                    </a>
                </li>
                
                 <li class="nav-item <?php echo e((request()->routeIs('tradinghistory')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/support')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-signal mr-2"></i>
                        <p class="mb-0">Recover Funds</p>
                    </a>
                </li>

                <li class="nav-item <?php echo e((request()->routeIs('referuser')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/referuser')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-life-ring mr-2"></i>
                        <p class="mb-0">Refer Users</p>
                    </a>
                </li>

                <li class="nav-item <?php echo e((request()->routeIs('support')) ? 'active' : ''); ?>">
                    <a href="<?php echo e(url('dashboard/support')); ?>" class="nav-link text-light px-3 py-2 rounded hover-bg-light d-flex align-items-center">
                        <i class="fa fa-bell mr-2"></i>
                        <p class="mb-0">Help/Support</p>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    /* Sidebar dark background */
    .sidebar {
        background-color: #1e1e2f; /* full dark background */
        transition: all 0.3s ease;
    }

    /* User name text */
    .sidebar .user .info a span {
        color: #fff !important;
    }

    /* Button hover */
    .nav-link:hover, .nav-link.hover-bg-light {
        background-color: #2a2a3d !important; /* slightly lighter dark on hover */
        color: #fff !important;
        transition: all 0.3s ease;
    }

    /* Active link */
    .sidebar .nav-primary .active > .nav-link {
        background-color: #2a2a3d;
        color: #fff;
    }

    /* User image hover */
    .sidebar .user img {
        border: 2px solid #444;
        transition: transform 0.3s ease;
    }
    .sidebar .user img:hover {
        transform: scale(1.1);
    }

    @media (max-width: 768px) {
        .sidebar {
            position: fixed;
            z-index: 1050;
            width: 250px;
            transform: translateX(-260px);
        }
        .sidebar.show {
            transform: translateX(0);
            transition: transform 0.3s ease;
        }
    }
</style>
<?php /**PATH /home2/victorio/federalstockbond.com/user/resources/views/user/sidebar.blade.php ENDPATH**/ ?>