<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Settings;
use App\Models\Plans;
use App\Models\User_plans;
use Illuminate\Support\Facades\Log;

class InvPlanController extends Controller
{
    /**
     * ✅ Add new Copy Trading Plan
     */
    public function addplan(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required|string|max:255',
                'price' => 'required|numeric',
                'min_price' => 'required|numeric',
                'max_price' => 'required|numeric',
                'minr' => 'required|numeric',
                'maxr' => 'required|numeric',
                'gift' => 'nullable|numeric',
                't_interval' => 'required|string|max:255',
                't_type' => 'required|string|max:255',
                't_amount' => 'required|string|max:255',
                'expiration' => 'required|string|max:255',
                'expert_name' => 'nullable|string|max:255',
                'strategy_overview' => 'nullable|string',
                'expert_image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
            ]);

            $imagePath = null;

            // ✅ Correct cPanel path: remove duplicate 'user'
            $destination = $_SERVER['DOCUMENT_ROOT'] . '/user/public/storage/experts';

            if (!file_exists($destination)) {
                mkdir($destination, 0777, true);
            }

            if ($request->hasFile('expert_image')) {
                $filename = uniqid() . '_' . time() . '.' . $request->file('expert_image')->getClientOriginalExtension();
                $request->file('expert_image')->move($destination, $filename);

                // Only store relative URL for HTML
                $imagePath = 'user/public/storage/experts/' . $filename;
            }

            $plan = new Plans();
            $plan->name = $request->name;
            $plan->price = $request->price;
            $plan->min_price = $request->min_price;
            $plan->max_price = $request->max_price;
            $plan->minr = $request->minr;
            $plan->maxr = $request->maxr;
            $plan->gift = $request->gift ?? 0;
            $plan->expected_return = $request->input('return');
            $plan->increment_type = $request->t_type;
            $plan->increment_interval = $request->t_interval;
            $plan->increment_amount = $request->t_amount;
            $plan->expiration = $request->expiration;
            $plan->type = 'Main';
            $plan->expert_name = $request->expert_name;
            $plan->strategy_overview = $request->strategy_overview;
            $plan->expert_image = $imagePath;
            $plan->save();

            return redirect()->back()->with('success', 'Copy Trading Plan created successfully!');
        } catch (\Exception $e) {
            Log::error('Error adding plan: ' . $e->getMessage());
            return redirect()->back()->with('danger', 'Server Error: ' . $e->getMessage());
        }
    }

    /**
     * ✅ Update Copy Trading Plan
     */
    public function updateplan(Request $request)
    {
        try {
            $plan = Plans::findOrFail($request->id);

            $request->validate([
                'name' => 'required|string|max:255',
                'price' => 'required|numeric',
                'min_price' => 'required|numeric',
                'max_price' => 'required|numeric',
                'minr' => 'required|numeric',
                'maxr' => 'required|numeric',
                'gift' => 'nullable|numeric',
                't_interval' => 'required|string|max:255',
                't_type' => 'required|string|max:255',
                't_amount' => 'required|string|max:255',
                'expiration' => 'required|string|max:255',
                'expert_name' => 'nullable|string|max:255',
                'strategy_overview' => 'nullable|string',
                'expert_image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
            ]);

            $destination = $_SERVER['DOCUMENT_ROOT'] . '/user/public/storage/experts';
            if (!file_exists($destination)) {
                mkdir($destination, 0777, true);
            }

            if ($request->hasFile('expert_image')) {
                // Remove old image if exists
                if ($plan->expert_image && file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $plan->expert_image)) {
                    unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $plan->expert_image);
                }

                $filename = uniqid() . '_' . time() . '.' . $request->file('expert_image')->getClientOriginalExtension();
                $request->file('expert_image')->move($destination, $filename);

                $plan->expert_image = 'user/public/storage/experts/' . $filename;
            }

            $plan->update([
                'name' => $request->name,
                'price' => $request->price,
                'min_price' => $request->min_price,
                'max_price' => $request->max_price,
                'minr' => $request->minr,
                'maxr' => $request->maxr,
                'gift' => $request->gift,
                'expected_return' => $request->input('return'),
                'increment_type' => $request->t_type,
                'increment_interval' => $request->t_interval,
                'increment_amount' => $request->t_amount,
                'expiration' => $request->expiration,
                'expert_name' => $request->expert_name,
                'strategy_overview' => $request->strategy_overview,
            ]);

            return redirect()->back()->with('success', 'Copy Trading Plan successfully updated!');
        } catch (\Exception $e) {
            Log::error('Error updating plan: ' . $e->getMessage());
            return redirect()->back()->with('danger', 'Server Error: ' . $e->getMessage());
        }
    }

    /**
     * ✅ Delete Copy Trading Plan
     */
    public function trashplan($id)
    {
        try {
            $plan = Plans::findOrFail($id);

            if ($plan->expert_image && file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $plan->expert_image)) {
                unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $plan->expert_image);
            }

            User_plans::where('plan', $id)->delete();
            User::where('plan', $id)->update(['plan' => 0]);
            $plan->delete();

            return redirect()->back()->with('success', 'Copy Trading Plan deleted successfully!');
        } catch (\Exception $e) {
            Log::error('Error deleting plan: ' . $e->getMessage());
            return redirect()->back()->with('danger', 'Server Error: ' . $e->getMessage());
        }
    }
}
