@extends('layouts.guest')

@section('title', 'Account sign in')

@section('styles')
@parent
<style>
    /* Body & Background */
    body {
        background: linear-gradient(135deg, #1a1a1a 0%, #2b2b2b 100%);
        color: #fff;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        position: relative;
        overflow: hidden;
    }

    body::before {
        content: '';
        position: absolute;
        top: -150px;
        left: -150px;
        width: 500px;
        height: 500px;
        background: rgba(13, 110, 253, 0.12); /* slightly darker */
        border-radius: 50%;
        transform: rotate(45deg);
        z-index: 0;
    }

    body::after {
        content: '';
        position: absolute;
        bottom: -200px;
        right: -100px;
        width: 400px;
        height: 400px;
        background: rgba(255, 193, 7, 0.12); /* slightly darker */
        border-radius: 50%;
        transform: rotate(-30deg);
        z-index: 0;
    }

    .auth {
        width: 100%;
        padding: 40px 0;
        position: relative;
        z-index: 1; /* login card above background */
    }

    .auth__logo {
        display: block;
        margin: 0 auto 20px auto;
        max-width: 150px;
    }

    .login-page {
        border-radius: 12px !important;
        background: #1e1e1e; /* Dark form background remains */
        color: #f1f1f1;
        overflow: hidden;
        box-shadow: 0 8px 20px rgba(0,0,0,0.4); /* slightly stronger shadow */
        position: relative;
        z-index: 2;
    }

    .card-title {
        font-size: 22px;
        font-weight: 700;
        margin-bottom: 15px;
        color: #fff;
    }

    .login-form label {
        font-weight: 600;
        font-size: 14px;
        color: #ccc; /* lighter on dark background */
    }

    .login-form input {
        border-radius: 10px;
        padding: 12px 15px 12px 40px;
        border: 1px solid #444;
        background: #2a2a2a;
        color: #fff;
        transition: all 0.2s ease-in-out;
    }

    .login-form input:focus {
        border-color: #0d6efd;
        background: #333;
        outline: none;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.3);
    }

    .login-form i {
        position: absolute;
        top: 50%;
        left: 12px;
        transform: translateY(-50%);
        color: #bbb;
    }

    .btn.pad {
        border-radius: 10px;
        padding: 12px;
        font-size: 16px;
        font-weight: bold;
        background: #0d6efd;
        border: none;
        transition: 0.3s ease-in-out;
    }

    .btn.pad:hover {
        background-color: #0b5ed7;
        transform: scale(1.03);
    }

    .forgot-pass a {
        font-size: 13px;
        color: #bbb;
    }

    .forgot-pass a:hover {
        color: #fff;
    }

    .alert {
        border-radius: 10px;
        font-size: 14px;
    }

    .text-center p {
        font-size: 14px;
        color: #ccc;
    }

    .text-center a {
        color: #0d6efd;
    }
    .text-center a:hover {
        color: #0b5ed7;
    }
</style>
@endsection

@section('content')
<section class="auth">
    <div class="container">
        <div class="pb-3 row justify-content-center">
            <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">

                <a href="/">
                    <img src="{{ asset('storage/app/public/photos/'.$settings->logo)}}" 
                         alt="Logo" class="mb-3 img-fluid auth__logo">
                </a>
                
                @if(Session::has('status'))
                    <div class="alert alert-primary alert-dismissible fade show" role="alert">
                        {{ session('status') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-primary">
                        <button type="button" class="text-white close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="shadow card login-page border-1">
                    <div class="card-body">
                        <h4 class="text-center card-title">Account sign in</h4>
                        <form method="POST" action="{{ route('login') }}"  class="mt-4 login-form">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Your Email <span class="text-primary">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="mail" class="fea icon-sm icons"></i>
                                            <input type="email" class="pl-5 form-control" name="email" value="{{ old('email') }}" id="email" placeholder="Email address" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Password <span class="text-primary">*</span></label>
                                        <div class="position-relative">
                                            <i data-feather="key" class="fea icon-sm icons"></i>
                                            <input type="password" class="pl-5 form-control" name="password" id="password" placeholder="Enter Password" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="d-flex justify-content-between">
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input"
                                                    id="customCheck1" name="remember">
                                                <label class="custom-control-label" for="customCheck1">Remember me</label>
                                            </div>
                                        </div>
                                        <p class="mb-0 forgot-pass"><a href="{{ route('password.request') }}" class="font-weight-bold">Forgot password ?</a></p>
                                    </div>
                                </div>

                                <div class="mb-0 col-lg-12">
                                    <button class="btn btn-primary btn-block pad" type="submit">Sign in</button>
                                </div>

                                <div class="mt-4 text-center col-lg-12">
                                    @if($settings->enable_social_login == "yes")
                                    <h6></h6>
                                    <div class="row"></div>
                                    @endif
                                </div>

                                <div class="text-center col-12">
                                    <p class="mt-3 mb-0"><small class="mr-2">Don't have an account ?</small> 
                                    <a href="{{ route('register') }}" class="font-weight-bold">Sign Up</a></p>
                                </div>

                                <div class="text-center col-12">
                                    <p class="mt-4 mb-0"><small class="mr-2">&copy; Copyright  
                                        {{date('Y')}} &nbsp; {{$settings->site_name}} &nbsp; All Rights Reserved.</small>
                                    </p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('scripts')
@parent
@endsection
