<?php
if (Auth('admin')->User()->dashboard_style == "light") {
    $text = "dark";
    $bg = 'light';
} else {
    $text = "light";
    $bg = 'dark';
}
?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="main-panel">
    <div class="content bg-<?php echo e(Auth('admin')->User()->dashboard_style); ?>">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-<?php echo e($text); ?>">Copy Trading Experts</h1>
                <p class="text-<?php echo e($text); ?>">Manage and monitor your investment and copy trading expert plans below.</p>
            </div>

            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>

            <div class="mb-5 row">
                <div class="mt-2 mb-3 col-lg-12">
                    <a class="btn btn-primary" href="<?php echo e(route('newplan')); ?>">
                        <i class="fa fa-plus"></i> Add New Expert Plan
                    </a>
                </div>

                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-lg-4 col-md-6">
                    <div class="card bg-<?php echo e($bg); ?> shadow border p-0 mb-4">

                        <!-- ✅ Expert Image -->
                        <?php
                            $expertImage = asset('assets/img/default-trader.jpg'); // Default fallback

                            if (!empty($plan->expert_image)) {
                                $path = $plan->expert_image;

                                // ✅ Normalize path
                                if (str_starts_with($path, '/public/storage/experts/')) {
                                    // Correct format from controller
                                    $expertImage = url($path);
                                } elseif (str_starts_with($path, 'storage/experts/')) {
                                    // Older saved format
                                    $expertImage = url('/public/' . $path);
                                } elseif (str_starts_with($path, '/storage/experts/')) {
                                    // Leading slash variant
                                    $expertImage = url('/public' . $path);
                                } elseif (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . ltrim($path, '/'))) {
                                    // Local absolute path
                                    $expertImage = url('/public/storage/experts/' . basename($path));
                                }
                            }
                        ?>

                        <img src="<?php echo e($expertImage); ?>" 
                             alt="<?php echo e($plan->expert_name ?? $plan->name); ?>" 
                             style="width:100%; height:220px; object-fit:cover; border-top-left-radius:10px; border-top-right-radius:10px;">

                        <!-- ✅ Card Body -->
                        <div class="p-3">
                            <h3 class="text-<?php echo e($text); ?> mb-1"><?php echo e($plan->name); ?></h3>

                            <?php if(!empty($plan->expert_name)): ?>
                                <p class="text-muted mb-2"><strong>Expert:</strong> <?php echo e($plan->expert_name); ?></p>
                            <?php endif; ?>

                            <?php if(!empty($plan->strategy_overview)): ?>
                                <p class="text-<?php echo e($text); ?>" style="font-size:14px;">
                                    <?php echo e(\Illuminate\Support\Str::limit($plan->strategy_overview, 90, '...')); ?>

                                </p>
                            <?php endif; ?>

                            <!-- ✅ Pricing -->
                            <div class="price-tag mb-3">
                                <span class="symbol text-<?php echo e($text); ?>"><?php echo e($settings->currency); ?></span>
                                <span class="amount text-<?php echo e($text); ?>"><?php echo e($plan->price); ?></span>
                            </div>

                            <!-- ✅ Plan Details -->
                            <div class="pricing-features">
                                <div class="feature text-<?php echo e($text); ?>">💼 Min Deposit:
                                    <span><?php echo e($settings->currency); ?><?php echo e($plan->min_price); ?></span>
                                </div>
                                <div class="feature text-<?php echo e($text); ?>">💰 Max Deposit:
                                    <span><?php echo e($settings->currency); ?><?php echo e($plan->max_price); ?></span>
                                </div>
                                <div class="feature text-<?php echo e($text); ?>">📈 ROI Range:
                                    <span><?php echo e($settings->currency); ?><?php echo e($plan->minr); ?> - <?php echo e($settings->currency); ?><?php echo e($plan->maxr); ?></span>
                                </div>
                                <div class="feature text-<?php echo e($text); ?>">🎁 Bonus:
                                    <span><?php echo e($settings->currency); ?><?php echo e($plan->gift); ?></span>
                                </div>
                                <div class="feature text-<?php echo e($text); ?>">⏳ Duration:
                                    <span><?php echo e($plan->expiration); ?></span>
                                </div>
                            </div>

                            <!-- ✅ Action Buttons -->
                            <div class="mt-3 text-center">
                                <a href="<?php echo e(route('editplan', $plan->id)); ?>" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                <a href="<?php echo e(url('admin/dashboard/trashplan')); ?>/<?php echo e($plan->id); ?>" 
                                   class="btn btn-danger btn-sm"
                                   onclick="return confirm('Are you sure you want to delete this plan?')">
                                    <i class="fa fa-trash"></i> Delete
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-lg-8">
                    <div class="pricing-table card border bg-<?php echo e($bg); ?> shadow p-4">
                        <h4 class="text-<?php echo e($text); ?>">No Copy Trading Plans available yet. Click the button above to create one.</h4>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/victorio/federalstockbond.com/user/resources/views/admin/Plans/plans.blade.php ENDPATH**/ ?>